' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox. 
' Polska edycja: Wydawnictwo Helion.
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com. 
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

Imports System.Data
Imports System.IO

Partial Class InsertUpdateDownload
  Inherits System.Web.UI.Page

  Private _id As Integer = -1

  Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
    If Request.QueryString.Get("id") IsNot Nothing Then
      _id = Convert.ToInt32(Request.QueryString.Get("id"))
      PageTitle.InnerText = "Edytuj download"
    Else
      PageTitle.InnerText = "Utwrz nowy download"
    End If
    If Not Page.IsPostBack Then
      LoadData()
    End If
  End Sub

  Private Sub LoadData()
    Dim myDownload As Download = Download.Get(_id)
    If myDownload IsNot Nothing Then
      txtTitle.Text = myDownload.Title
      txtDescription.Value = myDownload.Description
      If myDownload.DownloadUrl IsNot String.Empty Then
        hyperDownload.NavigateUrl = myDownload.DownloadUrl
        fsFile.Visible = True
      End If

      ' Teraz pobierz kategorie. Zapamitalimy tylko jeden poziom, wic musimy ustali
      ' co to za poziom, a nastpnie wypeni waciwe listy wyboru
      Dim dsCategories As DataSet = Category.GetCategoryPath(myDownload.CategoryId)
      If dsCategories.Tables.Count > 0 Then
        Dim myRow As DataRow = Nothing
        lstCategoryLevel1.Items.Clear()
        lstCategoryLevel2.Items.Clear()
        lstCategoryLevel3.Items.Clear()
        ' Zawsze powi poziom 1
        lstCategoryLevel1.DataBind()
        Select Case dsCategories.Tables(0).Rows.Count
          Case 1 ' Poziom 1 by zapamitany
            myRow = dsCategories.Tables(0).Rows(0)
            lstCategoryLevel1.Items.FindByValue(myRow("Id").ToString()).Selected = True
            lstCategoryLevel2.DataBind()
          Case 2 ' poziom 2 by zapamitany
            ' Row(0) zawiera element dla pierwszej listy rozwijanej, a Row(1) element dla drugiej
            myRow = dsCategories.Tables(0).Rows(0)
            lstCategoryLevel1.Items.FindByValue(myRow("Id").ToString()).Selected = True
            lstCategoryLevel2.DataBind()
            lstCategoryLevel2.SelectedIndex = -1
            myRow = dsCategories.Tables(0).Rows(1)
            lstCategoryLevel2.Items.FindByValue(myRow("Id").ToString()).Selected = True
            lstCategoryLevel3.DataBind()
          Case 3 ' poziom 3 by zapamitany
            ' Row(0) zawiera element dla pierwszej listy rozwijanej Row(1) element dla drugiej, a Row(2) dla trzeciej listy rozwijanej
            myRow = dsCategories.Tables(0).Rows(0)
            lstCategoryLevel1.Items.FindByValue(myRow("Id").ToString()).Selected = True
            lstCategoryLevel2.DataBind()
            lstCategoryLevel2.SelectedIndex = -1
            myRow = dsCategories.Tables(0).Rows(1)
            lstCategoryLevel2.Items.FindByValue(myRow("Id").ToString()).Selected = True
            lstCategoryLevel3.DataBind()
            lstCategoryLevel3.SelectedIndex = -1
            myRow = dsCategories.Tables(0).Rows(2)
            lstCategoryLevel3.Items.FindByValue(myRow("Id").ToString()).Selected = True
        End Select
      End If
    End If
  End Sub


  Protected Sub btnSave_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnSave.Click
    Page.Validate()
    ' Tu sprawd poprawno i zmie dane
    Dim title As String = String.Empty
    If txtTitle.Text.Length > 100 Then
      title = txtTitle.Text.Substring(0, 100)
    Else
      title = txtTitle.Text
    End If

    If Page.IsValid Then
      ' Zapisz obrazek
      Dim fullUploadLocation As String = String.Empty
      Dim fullUploadLocationMapped As String = String.Empty
      If fileUpload.HasFile Then
        Dim uploadName As String = Guid.NewGuid.ToString() & Path.GetExtension(fileUpload.PostedFile.FileName)
        Dim uploadFolderName As String = AppConfiguration.UploadFolder
        Dim uploadFolderNameMapped As String = Server.MapPath(uploadFolderName)
        If Not Directory.Exists(uploadFolderNameMapped) Then
          Directory.CreateDirectory(uploadFolderNameMapped)
        End If
        fullUploadLocation = Path.Combine(uploadFolderName, uploadName)
        fullUploadLocationMapped = Path.Combine(uploadFolderNameMapped, uploadName)
        fileUpload.SaveAs(fullUploadLocationMapped)
      End If

      Dim myDownload As Download
      If _id > -1 Then
        myDownload = Download.Get(_id)
      Else
        myDownload = New Download()
      End If

      myDownload.Title = txtTitle.Text
      myDownload.Description = txtDescription.Value

      ' Obsu kategori. Poziom 1 jest wymagany, numer 2 i 3 nie. Zapisujemy tylko najgbszy poziom
      If lstCategoryLevel3.SelectedIndex > 0 Then
        myDownload.CategoryId = Convert.ToInt32(lstCategoryLevel3.SelectedValue)
      ElseIf lstCategoryLevel2.SelectedIndex > 0 Then
        myDownload.CategoryId = Convert.ToInt32(lstCategoryLevel2.SelectedValue)
      Else
        myDownload.CategoryId = Convert.ToInt32(lstCategoryLevel1.SelectedValue)
      End If

      If fileUpload.HasFile Then
        myDownload.DownloadUrl = fullUploadLocation
      End If

      myDownload.Save()
      Response.Redirect("Downloads.aspx")
    End If
  End Sub

  Protected Sub btnCancel_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnCancel.Click
    Response.Redirect("Downloads.aspx")
  End Sub

  Protected Sub lstCategoryLevel2_DataBound(ByVal sender As Object, ByVal e As System.EventArgs) Handles lstCategoryLevel2.DataBound
    lstCategoryLevel2.Items.Insert(0, New ListItem("None", ""))
  End Sub

  Protected Sub lstCategoryLevel3_DataBound(ByVal sender As Object, ByVal e As System.EventArgs) Handles lstCategoryLevel3.DataBound
    lstCategoryLevel3.Items.Insert(0, New ListItem("None", ""))
  End Sub

  Protected Sub lstCategoryLevel1_SelectedIndexChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles lstCategoryLevel1.SelectedIndexChanged
    lstCategoryLevel3.Visible = False
  End Sub

  Protected Sub lstCategoryLevel2_SelectedIndexChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles lstCategoryLevel2.SelectedIndexChanged
    lstCategoryLevel3.Visible = True
  End Sub
End Class
